﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;

namespace Malefiz
{
    public abstract class Spielobjekt
    {
        Feldposition position = new Feldposition();

        /// <summary>
        /// In dieser Eigenschaft wird das Porträt dieser Spielfigur abgespeichert.
        /// </summary>
        public Image Porträt { get; set; }
        
        /// <summary>
        /// Die x-Koordinate der Spielfigur.
        /// </summary>
        public int X
        {
            get { return position.X; }
            set { position.X = value; }
        }

        /// <summary>
        /// Die y-Koordinate der Spielfigur.
        /// </summary>
        public int Y
        {
            get { return position.Y; }
            set { position.Y = value; }
        }

        /// <summary>
        /// Die Feldposition dieser Spielfigur.
        /// </summary>
        public Feldposition Position
        {
            get { return position; }
            set { position = value; }
        }

        /// <summary>
        /// Erstellt ein Spielobjekt - also eine Spielfigur oder eine Barrikade.
        /// </summary>
        public Spielobjekt()
        { }
    }
}